<?php

namespace App\Traits;

use App\Models\Settings;
use Illuminate\Support\Facades\Http;
use App\Models\SettingsCont;
use Illuminate\Http\Client\Response;

trait PingServer
{
    /**
     * Disabled - External server calls removed for privacy
     */
    public function callServer($action, $url, $data = [])
    {
        // External server calls disabled
        return Http::response(['success' => false, 'message' => 'External API disabled'], 200);
    }

    /**
     * Disabled - External API calls removed for privacy
     */
    public function fetctApi(string $url, array $data = [], string $method = 'GET'): Response
    {
        // External API calls disabled
        return Http::response(['success' => false, 'error' => true, 'message' => 'External API disabled'], 200);
    }

    public function backWithResponse(Response $response): array
    {
        $info = json_decode($response);

        if ($response->successful()) {
            if ($info->error) {
                $type = 'message';
            }
            if (!$info->error) {
                $type = 'success';
            }
            $message = $info->message;
        }

        if ($response->failed()) {
            $type = 'message';
            $message = $info->message;
        }

        return [
            'type' => $type,
            'message' => $message
        ];
    }
}
