<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReceiptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('receipts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('receipt_number')->unique();
            $table->string('user_name');
            $table->string('user_email');
            $table->decimal('amount', 20, 8);
            $table->string('cryptocurrency');
            $table->string('wallet_address');
            $table->string('transaction_type'); // deposit, withdrawal, trade, etc.
            $table->string('template_type'); // bybit, binance, coinbase
            $table->string('transaction_hash')->nullable();
            $table->decimal('fee_amount', 20, 8)->default(0);
            $table->string('fee_currency')->nullable();
            $table->string('network')->nullable(); // BTC, ETH, BSC, etc.
            $table->string('status')->default('completed'); // pending, completed, failed
            $table->text('notes')->nullable();
            $table->timestamp('transaction_date');
            $table->integer('created_by'); // admin user ID
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('receipts');
    }
}
