<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
    $bg = 'light';
} else {
    $text = 'light';
    $bg = 'dark';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content bg-{{ $bg }}">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1 text-{{ $text }}">Active Trade Copying</h1>
                </div>
                <x-danger-alert />
                <x-success-alert />
                <div class="col-12 card shadow p-4 bg-{{ Auth('admin')->User()->dashboard_style }}">
                    <div class="table-responsive" data-example-id="hoverable-table">
                        <table id="ShipTable" class="table table-hover text-{{ $text }}">
                            <thead>
                                <tr>
                                    <th>Expert Name</th>
                                    <th>Expert Tag</th>
                                    <th>User</th>
                                    <th>Invested</th>
                                    <th>Current Value</th>
                                    <th>Total P&L</th>
                                    <th>ROI %</th>
                                    <th>Trades</th>
                                    <th>Win Rate</th>
                                    <th>Date Created</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($copytrades as $copytrade)
                                    <tr>
                                        <td>{{ $copytrade->name ?? "N/A"}}</td>
                                        <td>{{ $copytrade->tag ?? "N/A"}}</td>
                                        <td>{{ $copytrade->cuser->name ?? "N/A"}}</td>
                                        <td>{{ $settings->currency }}{{ number_format($copytrade->price, 2) }}</td>
                                        <td>{{ $settings->currency }}{{ number_format($copytrade->current_balance ?? 0, 2) }}</td>
                                        <td class="{{ ($copytrade->total_profit ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ ($copytrade->total_profit ?? 0) >= 0 ? '+' : '' }}{{ $settings->currency }}{{ number_format($copytrade->total_profit ?? 0, 2) }}
                                        </td>
                                        <td class="{{ ($copytrade->profit_percentage ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ ($copytrade->profit_percentage ?? 0) >= 0 ? '+' : '' }}{{ number_format($copytrade->profit_percentage ?? 0, 2) }}%
                                        </td>
                                        <td>{{ $copytrade->total_trades ?? 0 }}</td>
                                        <td>{{ $copytrade->total_trades > 0 ? number_format(($copytrade->winning_trades / $copytrade->total_trades) * 100, 1) : 0 }}%</td>
                                        <td>{{ \Carbon\Carbon::parse($copytrade->created_at)->format('M d, Y') }}</td>
                                        <td>
                                            <button type="button" class="btn btn-primary btn-sm" 
                                                    data-toggle="modal" 
                                                    data-target="#editMetricsModal{{ $copytrade->id }}">
                                                <i class="fa fa-edit"></i> Edit Metrics
                                            </button>
                                        </td>
                                    </tr>

                                    <!-- Edit Metrics Modal -->
                                    <div class="modal fade" id="editMetricsModal{{ $copytrade->id }}" tabindex="-1" role="dialog">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content bg-{{ Auth('admin')->User()->dashboard_style }}">
                                                <div class="modal-header">
                                                    <h5 class="modal-title text-{{ $text }}">Edit Copy Trading Metrics</h5>
                                                    <button type="button" class="close text-{{ $text }}" data-dismiss="modal">
                                                        <span>&times;</span>
                                                    </button>
                                                </div>
                                                <form method="POST" action="{{ route('admin.copytrade.update.metrics') }}">
                                                    @csrf
                                                    <input type="hidden" name="copy_trade_id" value="{{ $copytrade->id }}">
                                                    <div class="modal-body">
                                                        <div class="mb-3">
                                                            <p class="text-{{ $text }}"><strong>User:</strong> {{ $copytrade->cuser->name ?? 'N/A' }}</p>
                                                            <p class="text-{{ $text }}"><strong>Expert:</strong> {{ $copytrade->name ?? 'N/A' }}</p>
                                                            <p class="text-{{ $text }}"><strong>Initial Investment:</strong> {{ $settings->currency }}{{ number_format($copytrade->price, 2) }}</p>
                                                        </div>
                                                        <hr>
                                                        <div class="form-group">
                                                            <label class="text-{{ $text }}">Total P&L ({{ $settings->currency }})</label>
                                                            <input type="number" step="0.01" class="form-control bg-{{ $bg }} text-{{ $text }}" 
                                                                   name="total_profit" 
                                                                   value="{{ $copytrade->total_profit ?? 0 }}" 
                                                                   required>
                                                            <small class="form-text text-muted">Can be positive (profit) or negative (loss)</small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="text-{{ $text }}">Current Balance ({{ $settings->currency }})</label>
                                                            <input type="number" step="0.01" class="form-control bg-{{ $bg }} text-{{ $text }}" 
                                                                   name="current_balance" 
                                                                   value="{{ $copytrade->current_balance ?? $copytrade->price }}" 
                                                                   required>
                                                            <small class="form-text text-muted">Current portfolio value</small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="text-{{ $text }}">Total Trades</label>
                                                            <input type="number" class="form-control bg-{{ $bg }} text-{{ $text }}" 
                                                                   name="total_trades" 
                                                                   value="{{ $copytrade->total_trades ?? 0 }}" 
                                                                   required>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="text-{{ $text }}">Winning Trades</label>
                                                            <input type="number" class="form-control bg-{{ $bg }} text-{{ $text }}" 
                                                                   name="winning_trades" 
                                                                   value="{{ $copytrade->winning_trades ?? 0 }}" 
                                                                   required>
                                                            <small class="form-text text-muted">Must be less than or equal to total trades</small>
                                                        </div>
                                                        <div class="alert alert-info">
                                                            <small><strong>Note:</strong> ROI % and Win Rate will be calculated automatically based on these values.</small>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                        <button type="submit" class="btn btn-primary">Save Changes</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @endsection
