<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transaction Receipt - {{ $receipt->receipt_number }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f8f9fa;
            color: #1e2329;
            line-height: 1.6;
        }

        .receipt-container {
            max-width: 800px;
            margin: 20px auto;
            background: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            border: 1px solid #e4e4e7;
        }

        .header {
            background: linear-gradient(135deg, #f0b90b 0%, #f8d12f 100%);
            padding: 30px;
            text-align: center;
            position: relative;
        }

        .header::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 0;
            height: 0;
            border-left: 15px solid transparent;
            border-right: 15px solid transparent;
            border-top: 10px solid #f0b90b;
        }

        .logo {
            font-size: 32px;
            font-weight: bold;
            color: #1e2329;
            margin-bottom: 8px;
            letter-spacing: 2px;
        }

        .receipt-title {
            font-size: 16px;
            color: #1e2329;
            font-weight: 500;
        }

        .receipt-number {
            background: rgba(30, 35, 41, 0.1);
            padding: 8px 16px;
            border-radius: 20px;
            display: inline-block;
            margin-top: 15px;
            font-weight: 600;
            font-size: 14px;
            color: #1e2329;
        }

        .content {
            padding: 30px;
        }

        .transaction-summary {
            background: linear-gradient(135deg, #fef7e0 0%, #fdf1c7 100%);
            border: 2px solid #f0b90b;
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 30px;
            text-align: center;
            position: relative;
        }

        .transaction-summary::before {
            content: '';
            position: absolute;
            top: -1px;
            left: -1px;
            right: -1px;
            bottom: -1px;
            background: linear-gradient(135deg, #f0b90b, #f8d12f);
            border-radius: 12px;
            z-index: -1;
        }

        .amount-display {
            font-size: 40px;
            font-weight: bold;
            color: #1e2329;
            margin-bottom: 10px;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .transaction-type {
            background: #1e2329;
            color: #f0b90b;
            padding: 10px 20px;
            border-radius: 25px;
            font-size: 14px;
            font-weight: bold;
            display: inline-block;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .details-section {
            margin-bottom: 25px;
        }

        .section-title {
            font-size: 18px;
            font-weight: bold;
            color: #1e2329;
            margin-bottom: 15px;
            padding-bottom: 8px;
            border-bottom: 2px solid #f0b90b;
            position: relative;
        }

        .section-title::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 50px;
            height: 2px;
            background: #1e2329;
        }

        .details-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 20px;
        }

        .detail-card {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            border-left: 4px solid #f0b90b;
        }

        .detail-item {
            margin-bottom: 15px;
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }

        .detail-label {
            color: #6c757d;
            font-size: 14px;
            font-weight: 500;
            min-width: 120px;
        }

        .detail-value {
            color: #1e2329;
            font-weight: 600;
            text-align: right;
            flex: 1;
            word-break: break-all;
        }

        .wallet-address {
            font-family: 'Courier New', monospace;
            font-size: 12px;
            background: #e9ecef;
            padding: 8px 12px;
            border-radius: 6px;
            border: 1px solid #dee2e6;
            color: #495057;
        }

        .status-badge {
            background: #28a745;
            color: white;
            padding: 6px 12px;
            border-radius: 15px;
            font-size: 12px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .full-width-section {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            border-left: 4px solid #f0b90b;
            margin-bottom: 20px;
        }

        .footer {
            background: #1e2329;
            color: #ffffff;
            padding: 25px 30px;
            text-align: center;
        }

        .footer-text {
            font-size: 12px;
            line-height: 1.6;
            opacity: 0.8;
        }

        .footer-logo {
            font-size: 20px;
            font-weight: bold;
            color: #f0b90b;
            margin-bottom: 10px;
        }

        .security-note {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 6px;
            padding: 15px;
            margin-bottom: 20px;
            font-size: 13px;
            color: #856404;
        }

        .qr-placeholder {
            width: 80px;
            height: 80px;
            background: #e9ecef;
            border: 2px solid #f0b90b;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            color: #6c757d;
            margin: 0 auto;
        }

        @media (max-width: 768px) {
            .details-grid {
                grid-template-columns: 1fr;
                gap: 15px;
            }

            .content {
                padding: 20px;
            }

            .amount-display {
                font-size: 32px;
            }
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <!-- Header -->
        <div class="header">
            <div class="logo">BINANCE</div>
            <div class="receipt-title">Official Transaction Receipt</div>
            <div class="receipt-number">Receipt # {{ $receipt->receipt_number }}</div>
        </div>

        <!-- Content -->
        <div class="content">
            <!-- Transaction Summary -->
            <div class="transaction-summary">
                <div class="amount-display">{{ number_format((float)$receipt->amount, 8) }} {{ strtoupper($receipt->cryptocurrency) }}</div>
                <div class="transaction-type">{{ $receipt->transaction_type }}</div>
            </div>

            <!-- User Information Section -->
            <div class="details-section">
                <div class="section-title">Account Information</div>
                <div class="details-grid">
                    <div class="detail-card">
                        <div class="detail-item">
                            <span class="detail-label">Account Holder:</span>
                            <span class="detail-value">{{ $receipt->user_name }}</span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Email Address:</span>
                            <span class="detail-value">{{ $receipt->user_email }}</span>
                        </div>
                    </div>
                    <div class="detail-card">
                        <div class="detail-item">
                            <span class="detail-label">Transaction Date:</span>
                            <span class="detail-value">{{ $receipt->transaction_date->format('M d, Y H:i:s') }} UTC</span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Status:</span>
                            <span class="detail-value"><span class="status-badge">{{ ucfirst($receipt->status) }}</span></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Transaction Details Section -->
            <div class="details-section">
                <div class="section-title">Transaction Details</div>
                <div class="details-grid">
                    <div class="detail-card">
                        <div class="detail-item">
                            <span class="detail-label">Asset:</span>
                            <span class="detail-value">{{ strtoupper($receipt->cryptocurrency) }}</span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Network:</span>
                            <span class="detail-value">{{ $receipt->network ?: 'Standard Network' }}</span>
                        </div>
                        @if($receipt->fee_amount > 0)
                        <div class="detail-item">
                            <span class="detail-label">Network Fee:</span>
                            <span class="detail-value">{{ number_format((float)$receipt->fee_amount, 8) }} {{ $receipt->fee_currency ?: $receipt->cryptocurrency }}</span>
                        </div>
                        @endif
                    </div>
                    <div class="detail-card">
                        <div class="detail-item">
                            <span class="detail-label">Total Amount:</span>
                            <span class="detail-value" style="font-size: 16px; color: #f0b90b;">{{ number_format((float)$receipt->amount, 8) }} {{ strtoupper($receipt->cryptocurrency) }}</span>
                        </div>
                        <div class="qr-placeholder">
                            QR Code
                        </div>
                    </div>
                </div>
            </div>

            <!-- Wallet Address Section -->
            <div class="full-width-section">
                <div class="section-title">Wallet Information</div>
                <div class="detail-item">
                    <span class="detail-label">Wallet Address:</span>
                    <span class="detail-value wallet-address">{{ $receipt->wallet_address }}</span>
                </div>
            </div>

            @if($receipt->transaction_hash)
            <!-- Blockchain Information -->
            <div class="full-width-section">
                <div class="section-title">Blockchain Verification</div>
                <div class="detail-item">
                    <span class="detail-label">Transaction Hash:</span>
                    <span class="detail-value wallet-address">{{ $receipt->transaction_hash }}</span>
                </div>
            </div>
            @endif

            @if($receipt->notes)
            <!-- Additional Notes -->
            <div class="full-width-section">
                <div class="section-title">Additional Information</div>
                <div class="detail-item">
                    <span class="detail-value">{{ $receipt->notes }}</span>
                </div>
            </div>
            @endif

            <!-- Security Notice -->
            <div class="security-note">
                <strong>Important:</strong> This is an official transaction receipt from Binance.
                Please verify all transaction details independently. For any discrepancies, contact our support team immediately.
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <div class="footer-logo">BINANCE</div>
            <div class="footer-text">
                Generated on {{ now()->format('F d, Y \a\t H:i:s') }} UTC<br>
                The world's largest cryptocurrency exchange<br>
                <strong>Security • Reliability • Innovation</strong>
            </div>
        </div>
    </div>
</body>
</html>
