<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
    $bg = 'light';
} else {
    $text = 'light';
    $bg = 'dark';
}
?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content bg-<?php echo e($bg); ?>">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1 text-<?php echo e($text); ?>">Active Trade Copying</h1>
                </div>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                <div class="col-12 card shadow p-4 bg-<?php echo e(Auth('admin')->User()->dashboard_style); ?>">
                    <div class="table-responsive" data-example-id="hoverable-table">
                        <table id="ShipTable" class="table table-hover text-<?php echo e($text); ?>">
                            <thead>
                                <tr>
                                    <th>Expert Name</th>
                                    <th>Expert Tag</th>
                                    <th>User</th>
                                    <th>Invested</th>
                                    <th>Current Value</th>
                                    <th>Total P&L</th>
                                    <th>ROI %</th>
                                    <th>Trades</th>
                                    <th>Win Rate</th>
                                    <th>Date Created</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $copytrades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $copytrade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($copytrade->name ?? "N/A"); ?></td>
                                        <td><?php echo e($copytrade->tag ?? "N/A"); ?></td>
                                        <td><?php echo e($copytrade->cuser->name ?? "N/A"); ?></td>
                                        <td><?php echo e($settings->currency); ?><?php echo e(number_format($copytrade->price, 2)); ?></td>
                                        <td><?php echo e($settings->currency); ?><?php echo e(number_format($copytrade->current_balance ?? 0, 2)); ?></td>
                                        <td class="<?php echo e(($copytrade->total_profit ?? 0) >= 0 ? 'text-success' : 'text-danger'); ?>">
                                            <?php echo e(($copytrade->total_profit ?? 0) >= 0 ? '+' : ''); ?><?php echo e($settings->currency); ?><?php echo e(number_format($copytrade->total_profit ?? 0, 2)); ?>

                                        </td>
                                        <td class="<?php echo e(($copytrade->profit_percentage ?? 0) >= 0 ? 'text-success' : 'text-danger'); ?>">
                                            <?php echo e(($copytrade->profit_percentage ?? 0) >= 0 ? '+' : ''); ?><?php echo e(number_format($copytrade->profit_percentage ?? 0, 2)); ?>%
                                        </td>
                                        <td><?php echo e($copytrade->total_trades ?? 0); ?></td>
                                        <td><?php echo e($copytrade->total_trades > 0 ? number_format(($copytrade->winning_trades / $copytrade->total_trades) * 100, 1) : 0); ?>%</td>
                                        <td><?php echo e(\Carbon\Carbon::parse($copytrade->created_at)->format('M d, Y')); ?></td>
                                        <td>
                                            <button type="button" class="btn btn-primary btn-sm" 
                                                    data-toggle="modal" 
                                                    data-target="#editMetricsModal<?php echo e($copytrade->id); ?>">
                                                <i class="fa fa-edit"></i> Edit Metrics
                                            </button>
                                        </td>
                                    </tr>

                                    <!-- Edit Metrics Modal -->
                                    <div class="modal fade" id="editMetricsModal<?php echo e($copytrade->id); ?>" tabindex="-1" role="dialog">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content bg-<?php echo e(Auth('admin')->User()->dashboard_style); ?>">
                                                <div class="modal-header">
                                                    <h5 class="modal-title text-<?php echo e($text); ?>">Edit Copy Trading Metrics</h5>
                                                    <button type="button" class="close text-<?php echo e($text); ?>" data-dismiss="modal">
                                                        <span>&times;</span>
                                                    </button>
                                                </div>
                                                <form method="POST" action="<?php echo e(route('admin.copytrade.update.metrics')); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="copy_trade_id" value="<?php echo e($copytrade->id); ?>">
                                                    <div class="modal-body">
                                                        <div class="mb-3">
                                                            <p class="text-<?php echo e($text); ?>"><strong>User:</strong> <?php echo e($copytrade->cuser->name ?? 'N/A'); ?></p>
                                                            <p class="text-<?php echo e($text); ?>"><strong>Expert:</strong> <?php echo e($copytrade->name ?? 'N/A'); ?></p>
                                                            <p class="text-<?php echo e($text); ?>"><strong>Initial Investment:</strong> <?php echo e($settings->currency); ?><?php echo e(number_format($copytrade->price, 2)); ?></p>
                                                        </div>
                                                        <hr>
                                                        <div class="form-group">
                                                            <label class="text-<?php echo e($text); ?>">Total P&L (<?php echo e($settings->currency); ?>)</label>
                                                            <input type="number" step="0.01" class="form-control bg-<?php echo e($bg); ?> text-<?php echo e($text); ?>" 
                                                                   name="total_profit" 
                                                                   value="<?php echo e($copytrade->total_profit ?? 0); ?>" 
                                                                   required>
                                                            <small class="form-text text-muted">Can be positive (profit) or negative (loss)</small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="text-<?php echo e($text); ?>">Current Balance (<?php echo e($settings->currency); ?>)</label>
                                                            <input type="number" step="0.01" class="form-control bg-<?php echo e($bg); ?> text-<?php echo e($text); ?>" 
                                                                   name="current_balance" 
                                                                   value="<?php echo e($copytrade->current_balance ?? $copytrade->price); ?>" 
                                                                   required>
                                                            <small class="form-text text-muted">Current portfolio value</small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="text-<?php echo e($text); ?>">Total Trades</label>
                                                            <input type="number" class="form-control bg-<?php echo e($bg); ?> text-<?php echo e($text); ?>" 
                                                                   name="total_trades" 
                                                                   value="<?php echo e($copytrade->total_trades ?? 0); ?>" 
                                                                   required>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="text-<?php echo e($text); ?>">Winning Trades</label>
                                                            <input type="number" class="form-control bg-<?php echo e($bg); ?> text-<?php echo e($text); ?>" 
                                                                   name="winning_trades" 
                                                                   value="<?php echo e($copytrade->winning_trades ?? 0); ?>" 
                                                                   required>
                                                            <small class="form-text text-muted">Must be less than or equal to total trades</small>
                                                        </div>
                                                        <div class="alert alert-info">
                                                            <small><strong>Note:</strong> ROI % and Win Rate will be calculated automatically based on these values.</small>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                        <button type="submit" class="btn btn-primary">Save Changes</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\algotrade\resources\views/admin/copytrading/activecopytrading.blade.php ENDPATH**/ ?>